var CONST_STORAGE_KEY_TOKEN = 'token';
var CONST_STORAGE_KEY_ID_SESSION = 'unicIDSessionPlugin';
var CONST_STORAGE_KEY_PLAYHEAD = 'playhead_setting';
var CONST_STORAGE_TEMP_PLAYHEAD = true;
var CONST_IFRAME_SRC = 'https://platform.krock.io/login';
var CONST_IFRAME_ORIGIN = 'https://platform.krock.io';
var CONST_IFRAME_AUTH = 'https://platform.krock.io/set-token';
// var CONST_IFRAME_SRC = 'https://go.devkrock.site/login';
// var CONST_IFRAME_ORIGIN = 'https://go.devkrock.site';
// var CONST_IFRAME_AUTH = 'https://go.devkrock.site/set-token';


function getSecureRandomString(length) {
	const characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
	const array = new Uint8Array(length);
	crypto.getRandomValues(array);
	return Array.from(array, byte => characters[byte % characters.length]).join('');
}
function secondsToFrameNumber(seconds, fps = 24) {
  return Math.round(seconds * fps);
}
function secondsToTimecode(seconds, fps = 24) {
    const totalFrames = Math.floor(seconds * fps);

    const frames = totalFrames % fps;
    const totalSeconds = Math.floor(totalFrames / fps);
    
    const secs = totalSeconds % 60;
    const totalMinutes = Math.floor(totalSeconds / 60);
    
    const mins = totalMinutes % 60;
    const hours = Math.floor(totalMinutes / 60);

    // DaVinci иногда использует "01" как стартовый час — можно форсировать
    const displayHours = hours > 0 ? hours.toString().padStart(2, '0') : '01';

    return `${displayHours}:${mins.toString().padStart(2, '0')}:${secs.toString().padStart(2, '0')}:${frames.toString().padStart(2, '0')}`;
}

async function syncPlayhead(time) {
    try {
        const timeline = await window.appAPI.getCurrentTimeline();
        const newTime = await timeline.SetPlayheadTime(time); // "01:00:07:22"
    } catch (error) {
        console.error('Error toggling playback:', error);
    }
}

async function addMarkers(startTime, fps, color, commenter, comment, duration) {
    try {
        const timeline = await window.appAPI.getCurrentTimeline();
        if (timeline) {
            try {
                let frame = secondsToFrameNumber(startTime, fps);
                let durationM = (duration > 0) ? secondsToFrameNumber(duration, fps) : 1;
                let metadata = "Meta:Krock.io:"+getSecureRandomString(13);
                let marker1 = timeline.AddMarker(frame, color, commenter, comment, durationM, metadata);
                //console.log('Added marker: ', frame, color, commenter, comment, durationM, metadata);
            } catch (error) {
                console.error('Error in marker operation:', error);
            }
        } else {
            console.error('Failed to get timeline object');
        }
    } catch (error) {
        console.error('Error adding markers:', error);
    }
}

async function clearMarkers() {
    try {
        //console.log('Toggle clearMarkers');
        const timeline = await window.appAPI.getCurrentTimeline();
        const markers = await timeline.GetMarkers();
        //console.log('All markers:', markers);

        if (markers && typeof markers === 'object') {
            for (const [frameId, marker] of Object.entries(markers)) {
                if (marker.customData && marker.customData.startsWith("Meta:Krock.io")) {
                    //console.log(marker.customData);
                    timeline.DeleteMarker(marker.customData);
                    //console.log('Deleting marker:', marker, 'at frame:', frameId);
                }
            }
        }
        statusMarkers();
    } catch (error) {
        console.error('Error clearMarkers:', error);
    }
}

async function statusMarkers() {
    try {
        const timeline = await window.appAPI.getCurrentTimeline();
        let counter = 0;
        const markers = await timeline.GetMarkers();
        // Используем Set для уникальных таймкодов (frameId)
        const uniqueFrames = new Set();
        if (markers && typeof markers === 'object') {
            for (const [frameId, marker] of Object.entries(markers)) {
                if (marker.customData && marker.customData.startsWith("Meta:Krock.io")) {
                    uniqueFrames.add(frameId);
                }
            }
        }
        counter = uniqueFrames.size;
        const statusText = document.getElementById('status');
        statusText.innerHTML = 'Imported: '+counter+' markers';
        return counter;
    } catch (error) {
        console.error('Error clearMarkers:', error);
    }
}

window.onload = async function () {
    let count = await statusMarkers();
    window.firstLoad = false;
}
document.addEventListener('DOMContentLoaded', () => {
    
    const syncPlayheadBtn = document.getElementById('syncPlayhead');
    const syncMarkersBtn = document.getElementById('syncMarkers');
    const removeMarkersBtn = document.getElementById('removeMarkers');
    
    // Playhead settings
    let playheadSettings = localStorage.getItem(CONST_STORAGE_KEY_PLAYHEAD);
    if(!playheadSettings){
        localStorage.setItem(CONST_STORAGE_KEY_PLAYHEAD, true);
    } else {
        var syncPlayheadBtnX = document.getElementById('syncPlayhead');
        if(playheadSettings === 'true'){
            syncPlayheadBtnX.classList.add("btn-active");
            CONST_STORAGE_TEMP_PLAYHEAD = true;
        } else {
            syncPlayheadBtnX.classList.remove("btn-active");
            CONST_STORAGE_TEMP_PLAYHEAD = false;
        }
    }
    //////////
    if (syncPlayheadBtn) {
        syncPlayheadBtn.addEventListener("click", () => {
            var syncPlayheadBtnX = document.getElementById('syncPlayhead');
            let playhead = localStorage.getItem(CONST_STORAGE_KEY_PLAYHEAD);
            if(playhead === 'true'){
                localStorage.setItem(CONST_STORAGE_KEY_PLAYHEAD, false);
                syncPlayheadBtnX.classList.remove("btn-active");
                CONST_STORAGE_TEMP_PLAYHEAD = false;
            } else {
                localStorage.setItem(CONST_STORAGE_KEY_PLAYHEAD, true);
                syncPlayheadBtnX.classList.add("btn-active");
                CONST_STORAGE_TEMP_PLAYHEAD = true;
            }
        });
    } else {
        console.error('syncPlayheadBtn not found');
    }
    
    if (syncMarkersBtn) {
        syncMarkersBtn.addEventListener("click", () => {
            var iframe = document.getElementById('iframe');
			const data = { typeEvent: 'checkInfoFile' };
			iframe.contentWindow.postMessage(data, CONST_IFRAME_ORIGIN);
        });
    } else {
        console.error('syncMarkersBtn not found');
    }

    if (removeMarkersBtn) {
        removeMarkersBtn.addEventListener('click', clearMarkers);
    } else {
        console.error('removeMarkersBtn not found');
    }

    // GEN LOGIC
    if(!window.firstLoad){
		var checkerAuthWrap = document.getElementById('checker-auth');
		var iframe = document.getElementById('iframe');
		let unicIDSessionPlugin = loadLS(CONST_STORAGE_KEY_ID_SESSION);
		if(!unicIDSessionPlugin){
			let unicID = getSecureRandomString(32);
			saveLS(CONST_STORAGE_KEY_ID_SESSION, unicID);
			unicIDSessionPlugin = unicID;
		}

		let token = loadLS(CONST_STORAGE_KEY_TOKEN);
		if(!token){
			let iframeSrc = CONST_IFRAME_SRC + '?plugin=DRS&unic-id-session-plugin='+unicIDSessionPlugin;
			window.firstLoad = true;
			iframe.src = iframeSrc;
		} else {
			let iframeSrc = CONST_IFRAME_AUTH + '?plugin=DRS&token='+token+'&unic-id-session-plugin='+unicIDSessionPlugin;
			window.firstLoad = true;
			iframe.src = iframeSrc;
		}
		sendAnalyticsEvent();
		const eventTimestamps = new Map();
		const EVENT_THRESHOLD = 1000; // miliseconds

		window.addEventListener('message', (event) => {
			if (!event.data || !event.data.event) return;
			const eventName = event.data.event;
			const now = Date.now();
			if (eventTimestamps.has(eventName)) {
				const lastTimestamp = eventTimestamps.get(eventName);
				if (now - lastTimestamp < EVENT_THRESHOLD) {
					return; // Ignore duplicate
				}
			}
			eventTimestamps.set(eventName, now);

			if(event.data.event == "startSession"){
				if(event.data.data){
					saveLS(CONST_STORAGE_KEY_TOKEN, event.data.data);
					iframe.src = CONST_IFRAME_AUTH + '?plugin=DRS&token='+event.data.data+'&unic-id-session-plugin='+unicIDSessionPlugin;
				}
			}
			if(event.data.event == "startGoogleAuth"){
				const authUrl = decodeURI(event.data.data);
				window.open(authUrl, '_blank');
				CheckAuthGoogle(unicIDSessionPlugin);
			}

			if(CONST_STORAGE_TEMP_PLAYHEAD == true){
				if(event.data.event == "playerChangeCurrentTime"){
					const timeInSeconds = parseFloat(event.data.data.currentTime);
                    const fps = parseFloat(event.data.data.fps);
					if (!isNaN(timeInSeconds)) {
						syncPlayhead(secondsToTimecode(timeInSeconds, fps));
				    }
                }
                if(event.data.event == "playerPlay"){
                    //PLAY
                    const timeInSeconds = parseFloat(event.data.data.currentTime);
                    const fps = parseFloat(event.data.data.fps);
                    if (!isNaN(timeInSeconds)) {
                        syncPlayhead(secondsToTimecode(timeInSeconds, fps));
                    }
                }
                if(event.data.event == "playerPause"){
                    //PAUSE
                    const timeInSeconds = parseFloat(event.data.data.currentTime);
                    const fps = parseFloat(event.data.data.fps);
                    if (!isNaN(timeInSeconds)) {
                        console.log("fps",fps);
                        syncPlayhead(secondsToTimecode(timeInSeconds, fps));
                    }
                }
            }

            if(event.data.event == "updateInfoFile" && event.data.status == "success"){
                (async () => {
                    try {
                        const response = await fetch(CONST_IFRAME_ORIGIN+'/api/web/v1/steps/fetch-public-markers'+'/?mediaId='+event.data.data.mediaId+'&token='+token);
                        if (!response.ok) {
                            alert("Please login Krock.io platform");
                            return;
                        }
                        const data = await response.json();

                        var markers = data.data;
                        importedMarkers = [];

                        // --- Group markers ---
                        const groupedMarkers = {};
                        for (const markerData of markers) {
                            const key = markerData.Timecode + '_' + markerData.fpsVideo;
                            if (!groupedMarkers[key]) groupedMarkers[key] = [];
                            groupedMarkers[key].push(markerData);
                        }

                        // Check duplicates
                        const hasDuplicates = Object.values(groupedMarkers).some(group => group.length > 1);
                        let importMode = 'normal'; // 'shift', 'skip', 'normal'

                        if (hasDuplicates) {
                            const choice = await ShowDialogMarkersAdd();
                            console.log(choice);
                            if (choice === 0) importMode = 'shift';
                            else if (choice === 1) importMode = 'skip';
                            else return;
                        }

                        const clear = await clearMarkers();
                        // --- Add markers ---
                        for (const group of Object.values(groupedMarkers)) {
                            const main = group[0];
                            const color = main.isDone ? 'Green' : 'Red';
                            let comment = main.Comment || '';
                            if (group.length > 1) {
                                comment += `\nView all comments for this timecode in Krock (${group.length - 1}).`;
                            }

                            // Logic choice
                            if (importMode === 'shift' && group.length > 1) {
                                let offset = 0;
                                for (const m of group) {
                                    const fps = m.fpsVideo || 24;
                                    addMarkers(
                                        m.Timecode + m.startOffsetSeconds + (offset / fps),
                                        m.fpsVideo,
                                        color,
                                        m.Commenter,
                                        m.Comment,
                                        (m.TimecodeEnd > 0) ? ((m.TimecodeEnd + m.startOffsetSeconds) - (m.Timecode + m.startOffsetSeconds)) : 0,
                                    );
                                    offset += 1;
                                }
                            } else {
                                addMarkers(
                                    main.Timecode + main.startOffsetSeconds,
                                    main.fpsVideo,
                                    color,
                                    main.Commenter,
                                    comment,
                                    (main.TimecodeEnd > 0) ? ((main.TimecodeEnd + main.startOffsetSeconds) - (main.Timecode + main.startOffsetSeconds)) : 0,
                                );
                            }
                        }

                        statusMarkers();

                    } catch (error) {
                        console.log('Error: '+error.message);
                    }
                })();
            } else if(event.data.event == "updateInfoFile" && event.data.status != "success"){
                alert("Please select a video file on the Krock.io platform");
            }
		}); 
	}

    async function ShowDialogMarkersAdd(){
        const choice = await window.appAPI.confirmDialog({
            title: 'Choose Import Method',
            message: '',
            detail:
            'Multiple markers found on the same frame. DaVinci Resolve allows only one marker per frame:\n\n' +
            '• Offset markers – Shift overlapping markers by one frame to keep all comments.\n\n' +
            '• Show first only – Import the first marker only. View all comments later in Krock.io.',
            buttons: ['Offset Markers', 'Show First Only'],
        });
        return choice;
    }

	async function sendAnalyticsEvent() {
			try {
				const response = await fetch(CONST_IFRAME_ORIGIN+"/api/web/v1/auth/plugin-login-event?plugin=DRS");
				const data = await response.json();
			} catch (error) {
				console.error("Error fetching data:", error);
			}
	}
	// Check Auth Google
	function CheckAuthGoogle(unicIDSessionPlugin){
		checkerAuthWrap.classList.add('active');
		let counter = 60;
		const counterElement = document.getElementById("counterAuth");

		function updateCounter() {
			counterElement.textContent = counter+' sec';
		}
		const interval = setInterval(() => {
			updateCounter();
			
			if (counter % 5 === 0) {
				sendRequest();
			}
			if (counter === 0) {
				clearInterval(interval);
				checkerAuthWrap.classList.remove('active');
			}
			counter--;
		}, 1000);
		async function sendRequest() {
			try {
				const response = await fetch(CONST_IFRAME_ORIGIN+"/api/web/v1/auth-plugin/fetch-auth?unic-id-session-plugin="+unicIDSessionPlugin);
				const data = await response.json();
				
				if (data.data.status === "success") {
					clearInterval(interval);
					checkerAuthWrap.classList.remove('active');

					saveLS(CONST_STORAGE_KEY_TOKEN, data.data.token);
					iframe.src = CONST_IFRAME_AUTH + '?plugin=DRS&token='+data.data.token+'&unic-id-session-plugin='+unicIDSessionPlugin;
				}
			} catch (error) {
				console.error("Error fetching data:", error);
			}
		}
		updateCounter();
	}

	function loadLS(name) {
		const savedValue = localStorage.getItem(name);
		if (savedValue) {
			return savedValue;
		}
	}
	function saveLS(name, value) {
		localStorage.setItem(name, value);
	}
});